/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#if defined(_MSC_VER)
# pragma data_seg("regconst_c","FAR_DATA")
#elif defined(__BORLANDC__)
# pragma option -dc
#endif /* _MSC_VER etc. */


#include <mini_api.h>

#define COMPILING_REGCONST_C
#include <regconst.h>
#undef COMPILING_REGCONST_C

/* SCR; 12.97; mechanism to permit code to operate with one of 2 different
 * register address sets...(i.e. unaltered 2925 and 2926).
 * Note that the register set arrays are uni-dimensional for speed.
 */

const b_int32 RegPciCommand[] =      {0x00UL, 0xABUL}; /* moved from 00 to ab, CZ */
const b_int32 RegBestStatusMini[] =  {0x01UL, 0xACUL}; /* moved from 01 to ac, CZ */
const b_int32 RegBoardRstmode[] =    {0x02UL, 0xADUL}; /* moved from 02 to ad, CZ */
const b_int32 RegBiosString[] =      {0xEBUL, 0x04UL}; /* moved from eb to 04, CZ */
const b_int32 RegProductString[] =   {0xECUL, 0x02UL}; /* moved from ec to 05 to 02, CZ, SCR */
const b_int32 RegDummyRegister[] =   {0xFFUL, 0x0AUL}; /* moved from ff to 0a, CZ */


/* forgive me ! ... this was the easiest was of setting up 2 lots of reg. widths... */

#define BOTH_B_SIZE_BYTE  {{B_SIZE_BYTE, B_SIZE_BYTE}}
#define BOTH_B_SIZE_WORD  {{B_SIZE_WORD, B_SIZE_WORD}}
#define BOTH_B_SIZE_DWORD {{B_SIZE_DWORD, B_SIZE_DWORD}}


/* actual register widths ... 1st value is for a 2925, 2nd for a 2926 */

const MULT_REG_WIDTHS b_regsize[256] = {

  /* BestControl Registers (0x00 .. 0x0F) */
  /* this first block requires a byte register size in any case!! CZ */

  {{B_SIZE_WORD,  B_SIZE_BYTE}}   ,     /* 00 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 01 */
    BOTH_B_SIZE_BYTE   ,                /* 02 PRODUCT_STRING...both MUST be BYTE !!! */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 03 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 04 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 05 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 06 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 07 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 08 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 09 */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 0A */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 0B */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 0C */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 0D */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* 0E */
    BOTH_B_SIZE_BYTE   ,     /* 0F */

  /* PCI Programming Registers (0x10 .. 0x1F) */

    BOTH_B_SIZE_DWORD  ,     /* 10 */
    BOTH_B_SIZE_DWORD  ,     /* 11 */
    BOTH_B_SIZE_BYTE   ,     /* 12 */
    BOTH_B_SIZE_BYTE   ,     /* 13 */
    BOTH_B_SIZE_DWORD  ,     /* 14 */
    BOTH_B_SIZE_DWORD  ,     /* 15 */
    BOTH_B_SIZE_DWORD  ,     /* 16 */
    BOTH_B_SIZE_DWORD  ,     /* 17 */
    BOTH_B_SIZE_DWORD  ,     /* 18 */
    BOTH_B_SIZE_DWORD  ,     /* 19 */
    BOTH_B_SIZE_BYTE   ,     /* 1A */
    BOTH_B_SIZE_BYTE   ,     /* 1B */
    BOTH_B_SIZE_BYTE   ,     /* 1C */
    BOTH_B_SIZE_BYTE   ,     /* 1D */
    BOTH_B_SIZE_BYTE   ,     /* 1E */
    BOTH_B_SIZE_DWORD  ,     /* 1F */

  /* MasterSeqControl (0x20 .. 0x2F) */
  /* 26 core: programming flash */
    BOTH_B_SIZE_BYTE   		,     /* 20 */
  {{B_SIZE_WORD, B_SIZE_BYTE}}  ,     /* 21 */
  {{B_SIZE_WORD, B_SIZE_BYTE}}  ,     /* 22 */
  {{B_SIZE_WORD, B_SIZE_BYTE}}  ,     /* 23 */
    BOTH_B_SIZE_BYTE   		,     /* 24 */
    BOTH_B_SIZE_BYTE  		,     /* 25 */
    BOTH_B_SIZE_BYTE  		,     /* 26 */
    BOTH_B_SIZE_BYTE   		,     /* 27 */
    BOTH_B_SIZE_BYTE   		,     /* 28 */
    BOTH_B_SIZE_BYTE  		,     /* 29 */
    BOTH_B_SIZE_BYTE   		,     /* 2A */
  {{B_SIZE_DWORD, B_SIZE_BYTE}} ,     /* 2B */
  {{B_SIZE_DWORD, B_SIZE_BYTE}} ,     /* 2C */
  {{B_SIZE_DWORD, B_SIZE_BYTE}} ,     /* 2D */
  {{B_SIZE_DWORD, B_SIZE_BYTE}} ,     /* 2E */
  {{B_SIZE_DWORD, B_SIZE_BYTE}} ,     /* 2F */

  /* ConfigSpaceAccess (0x30 .. 0x3F) */

    BOTH_B_SIZE_DWORD  ,     /* 30 */
    BOTH_B_SIZE_DWORD  ,     /* 31 */
    BOTH_B_SIZE_DWORD  ,     /* 32 */
    BOTH_B_SIZE_BYTE   ,     /* 33 */
    BOTH_B_SIZE_BYTE   ,     /* 34 */
    BOTH_B_SIZE_DWORD  ,     /* 35 */
    BOTH_B_SIZE_DWORD  ,     /* 36 */
    BOTH_B_SIZE_DWORD  ,     /* 37 */
    BOTH_B_SIZE_DWORD  ,     /* 38 */
    BOTH_B_SIZE_DWORD  ,     /* 39 */
    BOTH_B_SIZE_DWORD  ,     /* 3A */
    BOTH_B_SIZE_DWORD  ,     /* 3B */
    BOTH_B_SIZE_DWORD  ,     /* 3C */
    BOTH_B_SIZE_DWORD  ,     /* 3D */
    BOTH_B_SIZE_DWORD  ,     /* 3E */
    BOTH_B_SIZE_DWORD  ,     /* 3F */

  /* PCIProtocolObserver (0x40 .. 0x4F) */

    BOTH_B_SIZE_DWORD  ,     /* 40 */
    BOTH_B_SIZE_DWORD  ,     /* 41 */
    BOTH_B_SIZE_DWORD  ,     /* 42 */
    BOTH_B_SIZE_BYTE   ,     /* 43 */
    BOTH_B_SIZE_BYTE   ,     /* 44 */
    BOTH_B_SIZE_BYTE   ,     /* 45 */
    BOTH_B_SIZE_BYTE   ,     /* 46 */
    BOTH_B_SIZE_BYTE   ,     /* 47 */
    BOTH_B_SIZE_BYTE   ,     /* 48 */
    BOTH_B_SIZE_DWORD  ,     /* 49 */
    BOTH_B_SIZE_DWORD  ,     /* 4A */
    BOTH_B_SIZE_DWORD  ,     /* 4B */
    BOTH_B_SIZE_DWORD  ,     /* 4C */
    BOTH_B_SIZE_DWORD  ,     /* 4D */
    BOTH_B_SIZE_DWORD  ,     /* 4E */
    BOTH_B_SIZE_DWORD  ,     /* 4F */

  /* PCIExpansionROMAccess (0x50 .. 0x5F) */

    BOTH_B_SIZE_DWORD  ,     /* 50 */
    BOTH_B_SIZE_BYTE   ,     /* 51 */
    BOTH_B_SIZE_BYTE   ,     /* 52 */
    BOTH_B_SIZE_DWORD  ,     /* 53 */
    BOTH_B_SIZE_DWORD  ,     /* 54 */
    BOTH_B_SIZE_DWORD  ,     /* 55 */
    BOTH_B_SIZE_DWORD  ,     /* 56 */
    BOTH_B_SIZE_DWORD  ,     /* 57 */
    BOTH_B_SIZE_DWORD  ,     /* 58 */
    BOTH_B_SIZE_DWORD  ,     /* 59 */
    BOTH_B_SIZE_DWORD  ,     /* 5A */
    BOTH_B_SIZE_DWORD  ,     /* 5B */
    BOTH_B_SIZE_DWORD  ,     /* 5C */
    BOTH_B_SIZE_DWORD  ,     /* 5D */
    BOTH_B_SIZE_DWORD  ,     /* 5E */
    BOTH_B_SIZE_DWORD  ,     /* 5F */

  /* RAMAccess Registers (0x60 .. 0x6F) */

    BOTH_B_SIZE_DWORD  ,     /* 60 */
    BOTH_B_SIZE_DWORD  ,     /* 61 */
    BOTH_B_SIZE_BYTE   ,     /* 62 */
    BOTH_B_SIZE_DWORD  ,     /* 63 */
    BOTH_B_SIZE_DWORD  ,     /* 64 */
    BOTH_B_SIZE_DWORD  ,     /* 65 */
    BOTH_B_SIZE_DWORD  ,     /* 66 */
    BOTH_B_SIZE_DWORD  ,     /* 67 */
    BOTH_B_SIZE_DWORD  ,     /* 68 */
    BOTH_B_SIZE_DWORD  ,     /* 69 */
    BOTH_B_SIZE_DWORD  ,     /* 6A */
    BOTH_B_SIZE_DWORD  ,     /* 6B */
    BOTH_B_SIZE_DWORD  ,     /* 6C */
    BOTH_B_SIZE_DWORD  ,     /* 6D */
    BOTH_B_SIZE_DWORD  ,     /* 6E */
    BOTH_B_SIZE_DWORD  ,     /* 6F */

  /* LogicAnalyzer Registers (0x70 .. 0x7F) */

    BOTH_B_SIZE_WORD   ,     /* 70 */
    BOTH_B_SIZE_BYTE   ,     /* 71 */
    BOTH_B_SIZE_BYTE   ,     /* 72 */
    BOTH_B_SIZE_DWORD  ,     /* 73 */
    BOTH_B_SIZE_DWORD  ,     /* 74 */
    BOTH_B_SIZE_DWORD  ,     /* 75 */
    BOTH_B_SIZE_BYTE   ,     /* 76 */
    BOTH_B_SIZE_DWORD  ,     /* 77 */
    BOTH_B_SIZE_BYTE   ,     /* 78 */
    BOTH_B_SIZE_BYTE   ,     /* 79 */
    BOTH_B_SIZE_BYTE   ,     /* 7A */
    BOTH_B_SIZE_WORD   ,     /* 7B */
    BOTH_B_SIZE_BYTE   ,     /* 7C */
    BOTH_B_SIZE_DWORD  ,     /* 7D */
    BOTH_B_SIZE_DWORD  ,     /* 7E */
    BOTH_B_SIZE_DWORD  ,     /* 7F */

  /* AttributeMemAccess  (0x80 .. 0x8F) */

    BOTH_B_SIZE_DWORD  ,     /* 80 */
    BOTH_B_SIZE_DWORD  ,     /* 81 */
    BOTH_B_SIZE_DWORD  ,     /* 82 */
    BOTH_B_SIZE_DWORD  ,     /* 83 */
    BOTH_B_SIZE_DWORD  ,     /* 84 */
    BOTH_B_SIZE_DWORD  ,     /* 85 */
    BOTH_B_SIZE_DWORD  ,     /* 86 */
    BOTH_B_SIZE_BYTE   ,     /* 87 */
    BOTH_B_SIZE_BYTE   ,     /* 88 */
    BOTH_B_SIZE_DWORD  ,     /* 89 */
    BOTH_B_SIZE_DWORD  ,     /* 8A */
    BOTH_B_SIZE_DWORD  ,     /* 8B */
    BOTH_B_SIZE_DWORD  ,     /* 8C */
    BOTH_B_SIZE_DWORD  ,     /* 8D */
    BOTH_B_SIZE_DWORD  ,     /* 8E */
    BOTH_B_SIZE_DWORD  ,     /* 8F */

  /* Display Registers (0x90 .. 0x9F) */

    BOTH_B_SIZE_BYTE   ,     /* 90 */
    BOTH_B_SIZE_BYTE   ,     /* 91 */
    BOTH_B_SIZE_BYTE   ,     /* 92 */
    BOTH_B_SIZE_DWORD  ,     /* 93 */
    BOTH_B_SIZE_BYTE   ,     /* 94 */
    BOTH_B_SIZE_BYTE   ,     /* 95 */
    BOTH_B_SIZE_BYTE   ,     /* 96 */
    BOTH_B_SIZE_DWORD  ,     /* 97 */
    BOTH_B_SIZE_DWORD  ,     /* 98 */
    BOTH_B_SIZE_DWORD  ,     /* 99 */
    BOTH_B_SIZE_DWORD  ,     /* 9A */
    BOTH_B_SIZE_DWORD  ,     /* 9B */
    BOTH_B_SIZE_DWORD  ,     /* 9C */
    BOTH_B_SIZE_BYTE   ,     /* 9D */
    BOTH_B_SIZE_BYTE   ,     /* 9E */
    BOTH_B_SIZE_DWORD  ,     /* 9F */

  /* Sideband Port Register (0xA0 .. 0xAF) */

    BOTH_B_SIZE_DWORD  ,     /* A0 */
    BOTH_B_SIZE_BYTE   ,     /* A1 */
    BOTH_B_SIZE_BYTE   ,     /* A2 */
    BOTH_B_SIZE_DWORD  ,     /* A3 */
    BOTH_B_SIZE_DWORD  ,     /* A4 */
    BOTH_B_SIZE_DWORD  ,     /* A5 */
    BOTH_B_SIZE_DWORD  ,     /* A6 */
    BOTH_B_SIZE_DWORD  ,     /* A7 */
    BOTH_B_SIZE_DWORD  ,     /* A8 */
    BOTH_B_SIZE_DWORD  ,     /* A9 */
    BOTH_B_SIZE_DWORD  ,     /* AA */
  {{B_SIZE_DWORD, B_SIZE_WORD}}   ,     /* AB */
    BOTH_B_SIZE_DWORD  ,     /* AC */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* AD */
    BOTH_B_SIZE_DWORD  ,     /* AE */
  {{B_SIZE_DWORD, B_SIZE_BYTE}}   ,     /* AF */

  /* CPU Port Registers (0xB0 .. 0xBF) */

    BOTH_B_SIZE_BYTE   ,     /* B0 */
    BOTH_B_SIZE_WORD   ,     /* B1 */
    BOTH_B_SIZE_DWORD  ,     /* B2 */
    BOTH_B_SIZE_BYTE   ,     /* B3 */
    BOTH_B_SIZE_BYTE   ,     /* B4 */
    BOTH_B_SIZE_BYTE   ,     /* B5 */
    BOTH_B_SIZE_BYTE   ,     /* B6 */
    BOTH_B_SIZE_BYTE   ,     /* B7 */
    BOTH_B_SIZE_BYTE   ,     /* B8 */
    BOTH_B_SIZE_DWORD  ,     /* B9 */
    BOTH_B_SIZE_DWORD  ,     /* BA */
    BOTH_B_SIZE_DWORD  ,     /* BB */
    BOTH_B_SIZE_DWORD  ,     /* BC */
    BOTH_B_SIZE_DWORD  ,     /* BD */
    BOTH_B_SIZE_DWORD  ,     /* BE */
    BOTH_B_SIZE_DWORD  ,     /* BF */

  /* Architecture Download (0xC0 .. 0xCF)  */

    BOTH_B_SIZE_BYTE   ,     /* C0         CORE: BYTE */
    BOTH_B_SIZE_BYTE   ,     /* C1         CORE: BYTE */
    BOTH_B_SIZE_DWORD  ,     /* C2         CORE: DWORD */
    BOTH_B_SIZE_DWORD  ,     /* C3         CORE: DWORD */
    BOTH_B_SIZE_BYTE   ,     /* C4         CORE: BYTE */
    BOTH_B_SIZE_BYTE   ,     /* C5         CORE: BYTE, do NOT use this!!! */
    BOTH_B_SIZE_BYTE   ,     /* C6         CORE: BYTE */
    BOTH_B_SIZE_WORD   ,     /* C7 */
    BOTH_B_SIZE_BYTE   ,     /* C8 */
    BOTH_B_SIZE_DWORD  ,     /* C9 */
    BOTH_B_SIZE_DWORD  ,     /* CA */
    BOTH_B_SIZE_DWORD  ,     /* CB */
    BOTH_B_SIZE_DWORD  ,     /* CC */
    BOTH_B_SIZE_DWORD  ,     /* CD */
    BOTH_B_SIZE_DWORD  ,     /* CE */
    BOTH_B_SIZE_DWORD  ,     /* CF */

  /* Miscellaneous Registers (0xD0 .. 0xFF) */

    BOTH_B_SIZE_DWORD  ,     /* D0 */
    BOTH_B_SIZE_DWORD  ,     /* D1 */
    BOTH_B_SIZE_DWORD  ,     /* D2 */
    BOTH_B_SIZE_DWORD  ,     /* D3 */
    BOTH_B_SIZE_DWORD  ,     /* D4 */
    BOTH_B_SIZE_BYTE   ,     /* D5 */
    BOTH_B_SIZE_BYTE   ,     /* D6 */
    BOTH_B_SIZE_DWORD  ,     /* D7 */
    BOTH_B_SIZE_BYTE   ,     /* D8 */
    BOTH_B_SIZE_BYTE   ,     /* D9 */
    BOTH_B_SIZE_BYTE   ,     /* DA */
    BOTH_B_SIZE_BYTE   ,     /* DB */
    BOTH_B_SIZE_BYTE   ,     /* DC */
    BOTH_B_SIZE_BYTE   ,     /* DD */
    BOTH_B_SIZE_BYTE   ,     /* DE */
    BOTH_B_SIZE_DWORD  ,     /* DF */

    BOTH_B_SIZE_DWORD  ,     /* E0 */
    BOTH_B_SIZE_DWORD  ,     /* E1 */
    BOTH_B_SIZE_BYTE   ,     /* E2 */
    BOTH_B_SIZE_DWORD  ,     /* E3 */
    BOTH_B_SIZE_DWORD  ,     /* E4 */
    BOTH_B_SIZE_DWORD  ,     /* E5 */
    BOTH_B_SIZE_DWORD  ,     /* E6 */
    BOTH_B_SIZE_DWORD  ,     /* E7 */
    BOTH_B_SIZE_DWORD  ,     /* E8 */
    BOTH_B_SIZE_DWORD  ,     /* E9 */
    BOTH_B_SIZE_BYTE   ,     /* EA */
    BOTH_B_SIZE_BYTE   ,     /* EB */
    BOTH_B_SIZE_BYTE   ,     /* EC */
    BOTH_B_SIZE_BYTE   ,     /* ED */
    BOTH_B_SIZE_BYTE   ,     /* EE */
    BOTH_B_SIZE_BYTE   ,     /* EF */

    {{ B_SIZE_BYTE, B_SIZE_DWORD }}  	,     /* F0 */
    BOTH_B_SIZE_BYTE   			,     /* F1 */
    BOTH_B_SIZE_DWORD  			,     /* F2 */
    BOTH_B_SIZE_BYTE   			,     /* F3 */
    BOTH_B_SIZE_DWORD  			,     /* F4 */
    BOTH_B_SIZE_DWORD  			,     /* F5 */
    BOTH_B_SIZE_DWORD  			,     /* F6 */
    BOTH_B_SIZE_DWORD  			,     /* F7 */
    BOTH_B_SIZE_DWORD  			,     /* F8 */
    BOTH_B_SIZE_BYTE   			,     /* F9 */
    BOTH_B_SIZE_BYTE   			,     /* FA */
    BOTH_B_SIZE_BYTE   			,     /* FB */
    BOTH_B_SIZE_DWORD  			,     /* FC */
    BOTH_B_SIZE_DWORD  			,     /* FD */
    BOTH_B_SIZE_BYTE   			,     /* FE */
    BOTH_B_SIZE_DWORD    		      /* FF */

};



